/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.jdm.snmp.FullSnmpStats;
import ibm.nways.jdm.snmp.SnmpSession;

public class NodeAndCount {
    private SnmpSession session;
    protected int matchedIntervals = 16;
    protected short intervalMask = (short)-1;
    private int useCount;
    private boolean noRedShift = false;
    private String communityName;

    protected NodeAndCount(SnmpSession snmpSession, String string, boolean bl) {
        this.session = snmpSession;
        this.useCount = 0;
        this.communityName = string;
        this.noRedShift = bl;
    }

    protected synchronized SnmpSession getSession() {
        return this.session;
    }

    protected synchronized int getUseCount() {
        return this.useCount;
    }

    protected synchronized int getMatchedIntervals() {
        return this.matchedIntervals;
    }

    protected synchronized void addUse() {
        ++this.useCount;
    }

    protected synchronized void deleteUse() {
        --this.useCount;
    }

    protected synchronized void addMatchedInterval() {
        ++this.matchedIntervals;
        if ((this.intervalMask & 1) == 1) {
            --this.matchedIntervals;
        }
        this.intervalMask = (short)(this.intervalMask >> 1);
        this.intervalMask = (short)(this.intervalMask | 0x8000);
    }

    protected synchronized boolean addExceededInterval() {
        if ((this.intervalMask & 1) == 1) {
            --this.matchedIntervals;
        }
        this.intervalMask = (short)(this.intervalMask >> 1);
        this.intervalMask = (short)(this.intervalMask & Short.MAX_VALUE);
        boolean bl = false;
        if (this.isSlow()) {
            bl = true;
        }
        return bl;
    }

    public boolean isSlow() {
        return this.matchedIntervals < 12;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Dest:");
        stringBuffer.append(this.session.getIpAddress());
        stringBuffer.append(", ");
        stringBuffer.append(" communityName:");
        stringBuffer.append(this.communityName);
        stringBuffer.append(", ");
        stringBuffer.append(this.useCount);
        stringBuffer.append(" pollers, ");
        stringBuffer.append(this.matchedIntervals);
        stringBuffer.append("/16 on time, [");
        stringBuffer.append(Integer.toBinaryString(this.intervalMask & 0xFFFF));
        stringBuffer.append("], ");
        FullSnmpStats fullSnmpStats = this.session.getSnmpStats().getStats();
        stringBuffer.append(" sends:");
        stringBuffer.append(fullSnmpStats.sends);
        stringBuffer.append(", timeouts:");
        stringBuffer.append(fullSnmpStats.timeouts);
        stringBuffer.append(", retries:");
        stringBuffer.append(fullSnmpStats.retries);
        return stringBuffer.toString();
    }
}

